/*
Selectable
Copyright (c) 2017 Karl Saunders (http://mobius.ovh)
Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.

Version: 0.17.5

*/
(function(a,b){"object"==typeof exports?module.exports=b("Selectable"):"function"==typeof define&&define.amd?define([],b):a.Selectable=b("Selectable")})("undefined"==typeof global?this.window||this.global:global,function(){"use strict";function a(a,b){let c=[];b.forEach(b=>{let d=Math.hypot(b.rect.x1-parseInt(a.clientX),b.rect.y1-parseInt(a.clientY));c.push(parseInt(d))});let d=c.indexOf(Math.min(...c));return b[d].node}function b(a,c){return a&&a!==document.documentElement&&(c(a)?a:b(a.parentNode,c))}function c(a){return"[object Object]"===Object.prototype.toString.call(a)}function d(a){return Array.isArray(a)||a instanceof HTMLCollection||a instanceof NodeList}function e(a){return"isInteger"in Number?Number.isInteger(a):!isNaN(a)}function f(a,b){for(var d in b)if(b.hasOwnProperty(d)){var e=b[d];e&&c(e)?(a[d]=a[d]||{},f(a[d],e)):a[d]=e}return a}function g(a,b){var d=a.style;if(a){if(void 0===b)return window.getComputedStyle(a);if(c(b))for(var e in b)e in d||(e="-webkit-"+e),a.style[e]=b[e]+("string"==typeof b[e]?"":"opacity"===e?"":"px")}}function j(a){var c=window,e=a.getBoundingClientRect(),f=document.documentElement||document.body.parentNode||document.body,b=void 0===c.pageXOffset?f.scrollLeft:c.pageXOffset,d=void 0===c.pageYOffset?f.scrollTop:c.pageYOffset;return{x1:e.left+b,x2:e.left+e.width+b,y1:e.top+d,y2:e.top+e.height+d,height:e.height,width:e.width}}function k(a,b,c){var d;return function(){if(c=c||this,!d)return a.apply(c,arguments),d=!0,setTimeout(function(){d=!1},b)}}function l(a){var b=0,c=0;do b+=a.offsetTop||0,c+=a.offsetLeft||0,a=a.offsetParent;while(a);return{top:b,left:c}}function m(a,b,c,d,e){return e=e*Math.PI/180,{x:Math.cos(e)*(a-c)-Math.sin(e)*(b-d)+c,y:Math.sin(e)*(a-c)+Math.cos(e)*(b-d)+d}}function n(j,a){var b,k,m,p,q,s,u,w,z=[j,a];for(p=0;p<z.length;p++){var f=z[p];for(q=0;q<f.length;q++){var g=(q+1)%f.length,h=f[q],l=f[g],x=l.y-h.y,y=h.x-l.x;for(b=k=void 0,s=0;s<j.length;s++)m=x*j[s].x+y*j[s].y,(void 0===b||m<b)&&(b=m),(void 0===k||k<m)&&(k=m);for(u=w=void 0,s=0;s<a.length;s++)m=x*a[s].x+y*a[s].y,(void 0===u||m<u)&&(u=m),(void 0===w||w<m)&&(w=m);if(k<u||w<b)return!1}}return!0}var o="classList"in document.documentElement,q={add:function(b,a){o?b.classList.add(a):q.contains(b,a)||(b.className=b.className.trim()+" "+a)},remove:function(b,a){o?b.classList.remove(a):q.contains(b,a)&&(b.className=b.className.replace(new RegExp("(^|\\s)"+a.split(" ").join("|")+"(\\s|$)","gi")," "))},contains:function(b,a){if(b)return o?b.classList.contains(a):!!b.className&&!!b.className.match(new RegExp("(\\s|^)"+a+"(\\s|$)"))}},r=function(a){return!!a.ctrlKey||!!a.metaKey},s=function(a){return!!a.shiftKey},u=["x","y"],v={x:"x1",y:"y1"},w={x:"x2",y:"y2"},x=function(a){this.version="0.17.5",this.v=this.version.split(".").map(a=>parseInt(a,10)),this.touch="ontouchstart"in window||window.DocumentTouch&&document instanceof DocumentTouch,this.init(a)};return x.prototype={init:function(a){var b=this,e={filter:".ui-selectable",tolerance:"touch",appendTo:document.body,toggle:!1,autoRefresh:!0,throttle:50,lassoSelect:"normal",autoScroll:{threshold:0,increment:10},saveState:!1,ignore:!1,maxSelectable:!1,lasso:{border:"1px dotted #000",backgroundColor:"rgba(52, 152, 219, 0.2)"},keys:["shiftKey","ctrlKey","metaKey",""],classes:{lasso:"ui-lasso",selected:"ui-selected",container:"ui-container",selecting:"ui-selecting",selectable:"ui-selectable",deselecting:"ui-deselecting"}};this.config=f(e,a),this.origin={x:0,y:0},this.mouse={x:0,y:0};var h=this.config;this.autoscroll=c(h.autoScroll),this.lasso=!1,h.lasso&&c(h.lasso)&&(this.lasso=document.createElement("div"),this.lasso.className=h.classes.lasso,g(this.lasso,f({position:"absolute",boxSizing:"border-box",opacity:0},h.lasso))),this.touch&&(h.toggle=!1),this.events={},["_start","_touchstart","_drag","_end","_keyup","_keydown","_blur","_focus"].forEach(a=>{this.events[a]=this[a].bind(this)}),this.events._refresh=k(this.refresh,h.throttle,this),this.autoscroll&&(this.events._scroll=this._onScroll.bind(this)),this.setContainer(),this.scroll={x:this.bodyContainer?window.pageXOffset:this.container.scrollLeft,y:this.bodyContainer?window.pageYOffset:this.container.scrollTop},d(h.filter)?this.nodes=[].slice.call(h.filter):"string"==typeof h.filter&&(this.nodes=[].slice.call(this.container.querySelectorAll(h.filter))),this.nodes.forEach(a=>{q.add(a,h.classes.selectable)}),this.update(),this.enable(),setTimeout(function(){h.saveState&&b.state("save"),b.emit(15>b.v[1]?"selectable.init":"init")},10)},update:function(){this._loadItems(),this.refresh(),this.emit(15>this.v[1]?"selectable.update":"update",this.items)},refresh:function(){var a=window.innerWidth,b=window.innerHeight,c=this.bodyContainer?window.pageXOffset:this.container.scrollLeft,d=this.bodyContainer?window.pageYOffset:this.container.scrollTop;this.offsetWidth=this.container.offsetWidth,this.offsetHeight=this.container.offsetHeight,this.clientWidth=this.container.clientWidth,this.clientHeight=this.container.clientHeight,this.scrollWidth=this.container.scrollWidth,this.scrollHeight=this.container.scrollHeight,this.boundingRect=j(this.container),this.bodyContainer&&(this.boundingRect.x2=a,this.boundingRect.y2=b),this.scroll={x:c,y:d,max:{x:this.scrollWidth-(this.bodyContainer?a:this.clientWidth),y:this.scrollHeight-(this.bodyContainer?b:this.clientHeight)},size:{x:this.clientWidth,y:this.clientHeight},scrollable:{x:this.scrollWidth>this.offsetWidth,y:this.scrollHeight>this.offsetHeight}};for(var e=0;e<this.nodes.length;e++)this.items[e].rect=j(this.nodes[e]);this.emit(15>this.v[1]?"selectable.refresh":"refresh")},bind:function(){var a=this.events;this.unbind(),this.touch?(this.on(this.container,"touchstart",a._touchstart),this.on(document,"touchend",a._end),this.on(document,"touchcancel",a._end),!1!==this.lasso&&this.on(document,"touchmove",a._drag)):(this.on(this.container,"mousedown",a._start),this.on(document,"mouseup",a._end),this.on(document,"keydown",a._keydown),this.on(document,"keyup",a._keyup),this.on(this.container,"mouseenter",a._focus),this.on(this.container,"mouseleave",a._blur),!1!==this.lasso&&this.on(document,"mousemove",a._drag)),this.autoscroll&&this.on(this.bodyContainer?window:this.container,"scroll",a._scroll),this.on(window,"resize",a._refresh),this.on(window,"scroll",a._refresh)},unbind:function(){var a=this.events;this.off(this.container,"mousedown",a._start),this.off(document,"mousemove",a._drag),this.off(document,"mouseup",a._end),this.off(document,"keydown",a._keydown),this.off(document,"keyup",a._keyup),this.off(this.container,"mouseenter",a._focus),this.off(this.container,"mouseleave",a._blur),this.autoscroll&&this.off(this.bodyContainer?window:this.container,"scroll",a._scroll),this.off(this.container,"touchstart",a._start),this.off(document,"touchend",a._end),this.off(document,"touchcancel",a._end),this.off(document,"touchmove",a._drag),this.off(window,"resize",a._refresh),this.off(window,"scroll",a._refresh)},setContainer:function(a){var b,c=this.config;if(this.container&&(b=this.container,this.unbind()),a=a||c.appendTo,"string"==typeof a?this.container=document.querySelector(a):a instanceof Element&&a.nodeName&&(this.container=a),q.add(this.container,c.classes.container),b&&q.remove(b,c.classes.container),this.bodyContainer=this.container===document.body,this._loadItems(),this.autoscroll){var d=g(this.container);"static"!==d.position||this.bodyContainer||(this.container.style.position="relative")}this.bind()},select:function(a,b,c){var b=!!(1<arguments.length&&void 0!==arguments[1])&&arguments[1],c=!(2<arguments.length&&void 0!==arguments[2])||arguments[2];if(d(a)){for(var e=this.getSelectedItems().length,f=0;f<a.length&&(!this.config.maxSelectable||!(e>=this.config.maxSelectable));f++)this.select(a[f],!1,!1),e++;return c&&this.config.saveState&&this.state("save"),this.getSelectedItems()}if(a=this.get(a),a){if(this.config.toggle&&"drag"===this.config.toggle&&!b&&a.selected&&!this.cmdDown)return this.deselect(a,!1);var g=a.node,h=this.config.classes;return q.remove(g,h.selecting),q.add(g,h.selected),a.selecting=!1,a.selected=!0,a.startselected=!0,c&&this.config.saveState&&this.state("save"),this.emit(15>this.v[1]?"selectable.select":"selecteditem",a),a}return!1},deselect:function(a,b){if(d(a)){for(var c=0;c<a.length;c++)this.deselect(a[c],!1);return b&&this.config.saveState&&this.state("save"),this.getSelectedItems()}if(a=this.get(a),a){var e=a.node,f=this.config.classes;return a.selecting=!1,a.selected=!1,a.deselecting=!1,a.startselected=!1,q.remove(e,f.deselecting),q.remove(e,f.selecting),q.remove(e,f.selected),b&&this.config.saveState&&this.state("save"),this.emit(15>this.v[1]?"selectable.deselect":"deselecteditem",a),a}return!1},toggle:function(a){var b=this.get(a);if(b){d(b)||(b=[b]);for(var c=0;c<b.length;c++)b[c].selected?this.deselect(b[c],!1):this.select(b[c],!1,!1);this.config.saveState&&this.state("save")}},add:function(a){var b=[];"string"==typeof a&&(a=[].slice.call(this.container.querySelectorAll(a))),d(a)||(a=[a]);for(var c=0;c<a.length;c++)0>this.nodes.indexOf(a[c])&&a[c]instanceof Element&&(b.push(a[c]),q.add(a[c],this.config.classes.selectable));this.nodes=this.nodes.concat(b),this.update();for(var c=0;c<b.length;c++)this.emit("addeditem",this.get(b[c]))},remove:function(a,b){if(a=this.get(a),a){if(d(a))for(var c=a.length-1;0<=c;c--)this.remove(a[c],0<c);else{var e=a.node,f=this.config.classes,g=q.remove;g(e,f.selectable),g(e,f.deselecting),g(e,f.selecting),g(e,f.selected),this.nodes.splice(this.nodes.indexOf(a.node),1),this.emit("removeditem",a)}return b||this.update(),!0}return!1},selectAll:function(){if(!!this.config.maxSelectable&&this.config.maxSelectable<this.items.length)return this._maxReached();for(var a=0;a<this.items.length;a++)this.select(this.items[a],!0,!1);save&&this.config.saveState&&this.state("save")},invert:function(){var a=this.getItems();if(!!this.config.maxSelectable&&this.config.maxSelectable<a.length)return this._maxReached();for(var b,c=0;c<this.items.length;c++)b=this.items[c],b.selected?this.deselect(b,!1):this.select(b,!1,!1);this.config.saveState&&this.state("save")},clear:function(a){for(var a=!(0<arguments.length&&void 0!==arguments[0]),b=this.items.length-1;0<=b;b--)this.deselect(this.items[b],!1);a&&this.config.saveState&&this.state("save")},get:function(a){var b=!1;if("string"==typeof a&&(a=[].slice.call(this.container.querySelectorAll(a))),d(a)){b=[];for(var e,f=0;f<a.length;f++)e=this.get(a[f]),e&&b.push(e)}else isNaN(a)?a instanceof Element?b=this.items[this.nodes.indexOf(a)]:c(a)&&0<=this.items.indexOf(a)&&(b=a):0<=this.items.indexOf(this.items[a])&&(b=this.items[a]);return b},getItems:function(){return this.items},getNodes:function(){return this.nodes},getSelectedItems:function(a){return this.getItems().filter(function(b){return a?!b.selected:b.selected})},getSelectedNodes:function(){return this.getSelectedItems().map(function(a){return a.node})},state:function(a){var b=!1,c=!1;"save"===a?(this.states=this.states||[],this.states.push(this.getSelectedNodes()),e(this.config.saveState)&&this.states.length>this.config.saveState&&this.states.shift(),this.currentState=this.states.length-1,c=!0):"undo"===a?0<this.currentState&&(this.currentState--,b=!0,c=!0):"redo"===a?this.currentState<this.states.length-1&&(this.currentState++,b=!0,c=!0):"clear"===a?(this.states=[],this.currentState=!1):void 0,b&&(this.clear(!1),this.select(this.states[this.currentState],!1,!1)),c&&this.emit((15>this.v[1]?"selectable.state.":"state.")+a,this.states[this.currentState],this.states)},enable:function(){if(!this.enabled){var a=this.config.keys;this.enabled=!0,this.canShift=0<=a.indexOf("shiftKey"),this.canCtrl=0<=a.indexOf("ctrlKey"),this.canMeta=0<=a.indexOf("metaKey"),this.bind(),q.add(this.container,this.config.classes.container),this.emit(15>this.v[1]?"selectable.enable":"enabled")}return this.enabled},disable:function(){if(this.enabled){this.config.keys;this.enabled=!1,this.unbind(),q.remove(this.container,this.config.classes.container),this.emit(15>this.v[1]?"selectable.disable":"disabled")}return this.enabled},destroy:function(){this.disable(),this.listeners=!1,this.clear(),this.state("clear"),this.remove(this.items)},on:function(a,b){"string"==typeof a?(this.listeners=this.listeners||{},this.listeners[a]=this.listeners[a]||[],this.listeners[a].push(b)):arguments[0].addEventListener(arguments[1],arguments[2],!1)},off:function(a,b){if("string"==typeof a){if(this.listeners=this.listeners||{},!1==a in this.listeners)return;this.listeners[a].splice(this.listeners[a].indexOf(b),1)}else arguments[0].removeEventListener(arguments[1],arguments[2])},emit:function(a){if(this.listeners=this.listeners||{},!1!=a in this.listeners)for(var b=0;b<this.listeners[a].length;b++)this.listeners[a][b].apply(this,Array.prototype.slice.call(arguments,1))},_maxReached:function(){return this.emit("maxitems")},_touchstart:function(a){this.off(this.container,"mousedown",this.events.start),this._start(a)},_start:function(c){var d,e=this,f=this._getEvent(c),g=this.config,h=r(c)&&(this.canCtrl||this.canMeta),j=this.canShift&&s(c),k=this.getSelectedItems().length,l=g.maxSelectable;if(!!l&&k>=l&&(h||j||g.toggle))return this._maxReached();if(!(!this.container.contains(c.target)||3===c.which||0<c.button||g.disabled)){if(this.scroll.scrollable.y&&f.pageX>this.boundingRect.x1+this.scroll.size.x||this.scroll.scrollable.x&&f.pageY>this.boundingRect.y1+this.scroll.size.y)return!1;if(this.config.ignore){var m=!1,n=this.config.ignore;Array.isArray(n)||(n=[n]);for(var o,p=0;p<n.length;p++)if(o=c.target.closest(n[p]),o){m=!0;break}if(m)return!1}var t=b(c.target,function(a){return a===e.container||q.contains(a,g.classes.selectable)});if(!t)return!1;if(-1===["INPUT","SELECT","BUTTON","TEXTAREA","OPTION"].indexOf(c.target.tagName)&&c.preventDefault(),this.dragging=!0,this.origin={x:f.pageX+(this.bodyContainer?0:this.scroll.x),y:f.pageY+(this.bodyContainer?0:this.scroll.y),scroll:{x:this.scroll.x,y:this.scroll.y}},this.lasso&&this.container.appendChild(this.lasso),t!==this.container){var u=this.get(t);u.selecting=!0,q.add(t,g.classes.selecting)}else"sequential"==g.lassoSelect&&(t=a(f,this.items));if(g.autoRefresh&&this.refresh(),j&&this.startEl)for(var v=this.items,w=this.getNodes().indexOf(t),x=this.getNodes().indexOf(this.startEl),y=w<x?1:-1;(w+=y)&&w!==x;)v[w].selecting=!0;for(var p=0;p<this.items.length;p++){var u=this.items[p],z=u.node,A=z===t;if(u.selected){u.startselected=!0;var B=this.touch||g.toggle||h?A:!A&&!j;B&&(q.remove(z,g.classes.selected),u.selected=!1,q.add(z,g.classes.deselecting),u.deselecting=!0)}A&&(d=u)}this.startEl=t,this.emit(15>this.v[1]?"selectable.start":"start",c,d)}},_drag:function(a){var b=this.config;if(b.disabled||!this.dragging||s(a)&&this.canShift)return;let c;var d=this._getEvent(a),e=r(a)&&(this.canCtrl||this.canMeta);this.mouse={x:d.pageX,y:d.pageY},this.current={x1:this.origin.x,y1:this.origin.y,x2:this.mouse.x+(this.bodyContainer?0:this.scroll.x),y2:this.mouse.y+(this.bodyContainer?0:this.scroll.y)};for(var f,h=0;h<u.length;h++)f=u[h],this.current[v[f]]>this.current[w[f]]&&(c=this.current[w[f]],this.current[w[f]]=this.current[v[f]],this.current[v[f]]=c);if(this.coords={x1:this.current.x1,x2:this.current.x2-this.current.x1,y1:this.current.y1,y2:this.current.y2-this.current.y1},"normal"===b.lassoSelect)for(var h=0;h<this.items.length;h++)this._highlight(this.items[h],r(a)&&(this.canCtrl||this.canMeta),d);else"sequential"===b.lassoSelect&&this._sequentialSelect(d);this.autoscroll&&(!this.bodyContainer&&(this.coords.x1-=this.boundingRect.x1,this.coords.y1-=this.boundingRect.y1),this._autoScroll()),this.lasso&&(!this.bodyContainer&&this.autoscroll&&!this.config.autoScroll.lassoOverflow&&this._limitLasso(),g(this.lasso,{left:this.coords.x1,top:this.coords.y1,width:this.coords.x2,height:this.coords.y2,opacity:1})),this.emit(15>this.v[1]?"selectable.drag":"drag",a,this.coords)},_end:function(a){if(this.dragging){this.dragging=!1;var c,d=this,e=d.config,f=a.target,h=this._getEvent(a),j=[],k=[],l=this.getSelectedItems().length,m=e.maxSelectable;this.lasso&&this.container.contains(this.lasso)&&this.container.removeChild(this.lasso),this.lasso&&(g(this.lasso,{opacity:0,left:0,width:0,top:0,height:0}),f=document.elementFromPoint(h.pageX,h.pageY),!f&&(f=this.container)),c=b(f,function(a){return q.contains(a,e.classes.selectable)});for(var n,o=!1,p=0;p<this.items.length;p++)n=this.items[p],e.toggle&&n.node===c&&n.node===this.startEl&&n.selecting&&n.startselected&&(n.deselecting=!0,n.selecting=!1),n.deselecting&&(k.push(n),this.deselect(n,!1)),n.selecting&&(!!m&&l+j.length>=m?(n.selecting=!1,q.remove(n.node,e.classes.selecting),o=!0):(j.push(n),this.select(n,!1,!1)));if(e.saveState&&this.state("save"),this.emit(15>this.v[1]?"selectable.end":"end",a,j,k),o)return this._maxReached()}},_keydown:function(a){this.cmdDown=r(a)&&(this.canCtrl||this.canMeta);var b=!1;void 0===a.key?void 0!==a.keyCode&&(b=a.keyCode):b=a.key,b&&(this.cmdDown&&this.focused?65===b||"a"===b||"A"===b?this.selectAll():89===b||"y"===b||"Y"===b?this.state("redo"):90===b||"z"===b||"Z"===b?this.state("undo"):void 0:32===b||" "===b?this.toggle(document.activeElement):void 0)},_keyup:function(a){this.cmdDown=r(a)&&(this.canCtrl||this.canMeta)},_onScroll:function(){this.scroll.x=this.bodyContainer?window.pageXOffset:this.container.scrollLeft,this.scroll.y=this.bodyContainer?window.pageYOffset:this.container.scrollTop;for(var a=0;a<this.items.length;a++)this.items[a].rect=j(this.items[a].node)},_loadItems:function(){var a=this.config;if(this.nodes=[].slice.call(this.container.querySelectorAll("."+a.classes.selectable)),this.items=[],this.nodes.length)for(var b,c=0;c<this.nodes.length;c++){b=this.nodes[c],q.add(b,a.classes.selectable);var d={node:b,rect:j(b),startselected:!1,selected:q.contains(b,a.classes.selected),selecting:q.contains(b,a.classes.selecting),deselecting:q.contains(b,a.classes.deselecting)},e=this._get2DTransformation(b);if(e){for(var f=l(b),g=e.translate,k=e.origin,o=e.scale,r=b.offsetWidth,s=b.offsetHeight,h=f.left,t=f.top,u=k.x,v=k.y,w=r/2,x=s/2,y=h+(w-u)*o+u,z=t+(x-v)*o+v,A=w*o,B=x*o,C=[{x:y-A,y:z-B},{x:y+A,y:z-B},{x:y+A,y:z+B},{x:y-A,y:z+B}],p=0;3>=p;p++)C[p]=m(C[p].x+g.x,C[p].y+g.y,h+u+g.x,t+v+g.y,e.angle);d.transform={rect:C}}this.items.push(d)}},_getEvent:function(a){return this.touch?"touchend"===a.type?a.changedTouches[0]:a.touches[0]:a},_autoScroll:function(){var a=this.config.autoScroll,b=a.increment,c=a.threshold,d={x:0,y:0};this.bodyContainer&&(this.mouse.x-=this.scroll.x,this.mouse.y-=this.scroll.y);for(var e,f=0;f<u.length;f++)e=u[f],this.mouse[e]>=this.boundingRect[w[e]]-c&&this.scroll[e]<this.scroll.max[e]?d[e]=b:this.mouse[e]<=this.boundingRect[v[e]]+c&&0<this.scroll[e]&&(d[e]=-b);this.bodyContainer?window.scrollBy(d.x,d.y):(this.container.scrollTop+=d.y,this.container.scrollLeft+=d.x)},_limitLasso:function(){for(var a=0;a<u.length;a++){var b=u[a],c=this.boundingRect[v[b]]+this.scroll.size[b];if(this.mouse[b]>=c&&this.scroll[b]>=this.scroll.max[b]){var d=this.origin[b]-this.boundingRect[v[b]]-this.scroll[b];this.coords[v[b]]=this.origin[b]-this.boundingRect[v[b]],this.coords[w[b]]=c-d-this.boundingRect[v[b]]}this.mouse[b]<=this.boundingRect[v[b]]&&0>=this.scroll[b]&&(this.coords[v[b]]=0,this.coords[w[b]]=this.origin[b]-this.boundingRect[v[b]])}},_sequentialSelect:function(a){var b,d,e=this.config.classes,c=document.elementFromPoint(a.pageX,a.pageY-window.pageYOffset);if(c&&(c=c.closest(`.${e.selectable}`),c)){this.mouse.y>this.origin.y?(b=this.nodes.indexOf(this.startEl),d=this.nodes.indexOf(c)):this.mouse.y<this.origin.y&&(b=this.nodes.indexOf(c),d=this.nodes.indexOf(this.startEl));for(var f,g=0;g<this.items.length;g++)f=this.items[g],g>=b&&g<=d?this._highlight(f,r(a)&&(this.canCtrl||this.canMeta)):(f.selecting=!1,f.node.classList.remove(e.selecting))}},_highlight:function(b,c){var d=this.config,e=b.node,f=!1,g=this.bodyContainer?0:this.scroll.x,h=this.bodyContainer?0:this.scroll.y;if("normal"!==d.lassoSelect)f=!0;else if("touch"!==d.tolerance)"fit"===d.tolerance&&(f=b.rect.x1+g>this.current.x1&&b.rect.x2+g<this.current.x2&&b.rect.y1+h>this.current.y1&&b.rect.y2+h<this.current.y2);else if(b.transform){var i=[{x:this.origin.x,y:this.origin.y},{x:this.mouse.x+g,y:this.origin.y},{x:this.mouse.x+g,y:this.mouse.y+h},{x:this.origin.x,y:this.mouse.y+h}];f=n(i,b.transform.rect)}else f=!(b.rect.x1+g>this.current.x2||b.rect.x2+g<this.current.x1||b.rect.y1+h>this.current.y2||b.rect.y2+h<this.current.y1);f?(b.selected&&!d.toggle&&(q.remove(e,d.classes.selected),b.selected=!1),b.deselecting&&(!d.toggle||d.toggle&&"drag"!==d.toggle)&&(q.remove(e,d.classes.deselecting),b.deselecting=!1),!b.selecting&&(q.add(e,d.classes.selecting),b.selecting=!0)):(b.selecting&&(q.remove(e,d.classes.selecting),b.selecting=!1,c&&b.startselected?(q.add(e,d.classes.selected),b.selected=!0):b.startselected&&!d.toggle&&(q.add(e,d.classes.deselecting),b.deselecting=!0)),e.selected&&!c&&!b.startselected&&(q.remove(e,d.classes.selected),b.selected=!1,q.add(e,d.classes.deselecting),b.deselecting=!0))},_focus:function(){this.focused=!0,q.add(this.container,"ui-focused")},_blur:function(){this.focused=!1,q.remove(this.container,"ui-focused")},_get2DTransformation:function(b){var c=window.getComputedStyle(b,null),d=c.getPropertyValue("-webkit-transform")||c.getPropertyValue("-moz-transform")||c.getPropertyValue("-ms-transform")||c.getPropertyValue("-o-transform")||c.getPropertyValue("transform")||!1;if(d&&"none"!==d){var f=d.split("(")[1].split(")")[0].split(", "),e=parseFloat(f[0]),a=parseFloat(f[1]),g=Math.sqrt(e*e+a*a),h=c.transformOrigin.split(" ").map(a=>parseFloat(a));return{angle:Math.round(Math.atan2(a,e)*(180/Math.PI)),scale:g,origin:{x:parseFloat(h[0]),y:parseFloat(h[1])},translate:{x:parseFloat(f[4]),y:parseFloat(f[5])}}}return!1}},x});